/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.multiblock.apt;

import fr.iglee42.evolvedmekanism.EvolvedMekanism;
import fr.iglee42.evolvedmekanism.multiblock.apt.APTMultiblockData;
import fr.iglee42.evolvedmekanism.registries.EMBlocks;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityAPTCasing
extends TileEntityMultiblock<APTMultiblockData> {
    private boolean handleSound;
    private boolean prevActive;

    public TileEntityAPTCasing(BlockPos pos, BlockState state) {
        this((IBlockProvider)EMBlocks.APT_CASING, pos, state);
    }

    public TileEntityAPTCasing(IBlockProvider provider, BlockPos pos, BlockState state) {
        super(provider, pos, state);
    }

    protected boolean onUpdateServer(APTMultiblockData multiblock) {
        boolean active;
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        boolean bl = active = multiblock.isFormed() && multiblock.handlesSound(this) && multiblock.progress > 0;
        if (active != this.prevActive) {
            this.prevActive = active;
            needsPacket = true;
        }
        return needsPacket;
    }

    public APTMultiblockData createMultiblock() {
        return new APTMultiblockData(this);
    }

    public MultiblockManager<APTMultiblockData> getManager() {
        return EvolvedMekanism.aptManager;
    }

    protected boolean canPlaySound() {
        APTMultiblockData multiblock = (APTMultiblockData)this.getMultiblock();
        return multiblock.isFormed() && this.handleSound && multiblock.progress > 0;
    }

    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        APTMultiblockData multiblock = (APTMultiblockData)this.getMultiblock();
        updateTag.m_128379_("handleSound", multiblock.isFormed() && multiblock.handlesSound(this));
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"handleSound", value -> {
            this.handleSound = value;
        });
    }
}

